﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Masters.Category
{
    public partial class EditCategory : System.Web.UI.Page
    {
        private ProductCategory myCategory;

        protected void Page_Load(object sender, EventArgs e)
        {
          WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                if (Request.QueryString["UniqueID"] != null)
                {
                    hdProductCategoryID.Value = Request.QueryString["UniqueID"].ToString();
                    ShowProductCategory();
                }
            }
        }

        private void ShowProductCategory()
        {
            myCategory = ProductCategoryBL.GetItem(Guid.Parse(hdProductCategoryID.Value.Trim()), string.Empty);
            if (myCategory != null)
            {
                hdProductCategoryID.Value = myCategory.UniqueID.ToString();
                txtCategoryName.Text = myCategory.CategoryName;
                txtSequenceNo.Text = myCategory.SequenceNo.ToString();
                chkIsActive.Checked = myCategory.IsActive;
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (ValidatePageValue())
            {
                myCategory = new ProductCategory();
                if (hdProductCategoryID.Value.Trim().Length == 0)
                    myCategory.Mode = GlobalConfigurations.Mode.Insert;
                else
                {
                    myCategory.Mode = GlobalConfigurations.Mode.Update;
                    myCategory.UniqueID = Guid.Parse(hdProductCategoryID.Value.Trim());
                }

                myCategory.CategoryName = txtCategoryName.Text.Trim();
                myCategory.SequenceNo = int.Parse(txtSequenceNo.Text.Trim());
                myCategory.IsActive = chkIsActive.Checked;
                myCategory.UserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                if (ProductCategoryBL.Save(myCategory))
                {
                    WebUtilities.OpenNewAddEditDialog(this, "Success", "Product Category details has been saved successfully.<br>Do you want to add another Product Category?", this.ResolveClientUrl("~/Admin/Masters/Category/Categories.aspx"));
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/Masters/Category/Categories.aspx", false);
        }

        private bool ValidatePageValue()
        {
            if (!ValidationUtility.ValidateString(txtCategoryName.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtCategoryName.ClientID + "', 'Please enter Product Category Name.'); ", true);
                return false;
            }

            if (!ValidationUtility.ValidateInt(txtSequenceNo.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtSequenceNo.ClientID + "', 'Please enter valid Display Order.'); ", true);
                return false;
            }

            return true;
        } 
    }
}